/**
  * Sendmail version 1.0.0
  * Steve Kemp
  *
  */

#include "SendMail.h"




/**
  * Main entry point to code.
  */
int main( int argc, char *argv[] )
{
  // Message
  CMIMEMessage msg;

  // Mail interface
  CSMTP smtp( "butterfly" );

  // Argument processing
  int c;

  // Buffer, and stream for reading message from
  char lineBuffer[ 1000 ];
  int lineBufferSize = 999;
  ifstream input; // The handle to the input file


  // Markers to see if the user has filled in enough
  // parameteres to send mail.
  int server, subject, to, from;
  server = subject = to = from = 0;

  // Process the arguements.
  while ( (c =  getopt(argc, argv, "t:f:s:b:a:m:")) != EOF)
  {
    switch(c)
	{
			case ':':
				usage();
				break;
            case 'm':
                smtp.SetServerProperties( CString( optarg ) );
                server = 1;
                break;

            case 't': 
                msg.AddRecipient( CString( optarg ) );
                to = 1;
                break;
            case 'f':
                msg.m_sFrom = CString( optarg );
                from = 1;
                break;
            case 's':
                msg.m_sSubject = CString( optarg );
                subject = 1;
                break;
            case 'b':
                input.open( optarg, ios::in );
                if (input == NULL )
                { printf( "Error opening input file :%s\n", optarg );
                  return 1;
                }
                while( input.getline( lineBuffer , lineBufferSize ) )
                { msg.m_sBody += lineBuffer;
                  msg.m_sBody += "\r\n";
                }
                break;
            case 'a':
                msg.AddMIMEPart( CString( optarg ) );
                break;        
        }
  }

  // Only send mail if we have enought parameters.
  if ( to && from && server )
  {

    if ( !subject )
       msg.m_sSubject = CString( "[No Subject]" );
    
    smtp.Connect();
    smtp.SendMessage( &msg );
    smtp.Disconnect();       
  
    printf( "Sent.\n" );
  }
  else
    usage();

  return 0;
}


/**
  * Print usage information.
  */
void usage()
{
  printf( "Insufficient options, valid options are:\n\n" );
  printf ( "\t-t recipient -f sender -s subject -b filename -a filename -m mailserver\n" );
  printf ( "\t-t user@host.com\n" );
  printf ( "\t-f user@host.com\n" );
  printf ( "\t-s Mail subject\n" );
  printf ( "\t-b Text file to use for body of the message.\n" );
  printf ( "\t-a Filename of an attachment to include.\n" );
  printf ( "\t-m Mailhost.\n" );
  printf ( "\n[Attatchments are optional, and there may be multiple recipients specified.]\n\n" );
}

